-- name: Warp
-- incompatible: gamemode
-- description: In-game accessible warp functions.\nType "/warp help" or "/warp help2" for a list of available commands.\n\nMade mostly by anonymous\nversion 1.00

--Multiple types of desyncs can if any player has a weak machine or spotty connection. Multiple people trying to use reset or restart commands at the exact same time or coop.net being fucked up might cause problems too.
gGlobalSyncTable.saveDue = false --Can't allow players in multiplayer to manually call save_pos() and load_pos() anymore since it's a part of gGlobalSyncTable now instead of staying local.
gGlobalSyncTable.ipopups = true --Global pop-ups enabled by default.
gGlobalSyncTable.HostOnly = false --Warp commands available to everyone by default.

--Checks to see if other players are in the same level, area, and star as the level restart initiator.
--Idea is taken from the "Force Level" mod.
gGlobalSyncTable.sameLevel = 16 
gGlobalSyncTable.sameArea = 1
gGlobalSyncTable.sameAct = 0

local resetDue = false

local save_y = nil
local save_x = nil
local save_z = nil
local save_angle_y = nil
local save_angle_x = nil

local local_popup_state = true --Local pop-ups enabled by default.
local pauseMenuShowLevelID = false

local hide_attempt = false

--Taken from the "Object Spawner" mod to sanitize chat command inputs.
local function strip_colors(name)
    local string = ''
    local inSlash = false
    for i = 1, #name do
        local character = name:sub(i,i)
        if character == '\\' then inSlash = not inSlash
        elseif not inSlash then string = string .. character end
    end
    return string
end

local function local_popup(msg, state)
    if state then djui_popup_create(msg, 2) end
end

local function mask_attempt(m) --Attempt to make the level reset more smooth and obvious.
    if hide_attempt then
        play_sound(SOUND_MENU_MARIO_CASTLE_WARP2, m.marioObj.header.gfx.cameraToObject)
        m.particleFlags = PARTICLE_MIST_CIRCLE
        play_transition(WARP_TRANSITION_FADE_FROM_STAR, 14, 255, 255, 255)
        hide_attempt = false
    end
end

--Modified functions from GroovyBeardLover's "Save and Load Position" mod. Very simple in hindsight but I needed something that I knew that definitely works to bug test the "/warp reset" command.
local function save_pos()
    if gGlobalSyncTable.saveDue then
        save_y = gMarioStates[0].pos.y
        save_x = gMarioStates[0].pos.x
        save_z = gMarioStates[0].pos.z
        save_angle_y = gMarioStates[0].faceAngle.y
        save_angle_x = gMarioStates[0].faceAngle.x
    end
end

local function load_pos()
    if resetDue then
        if save_y ~= nil then
            gMarioStates[0].pos.y = save_y
            gMarioStates[0].pos.x = save_x
            gMarioStates[0].pos.z = save_z
            gMarioStates[0].faceAngle.y = save_angle_y
            gMarioStates[0].faceAngle.x = save_angle_x
            
            hide_attempt = true

            save_y, save_x, save_z, save_angle_y, save_angle_x = nil
        else log_to_console("Load failed. save_y == nil") end
        resetDue = false
        gGlobalSyncTable.saveDue = false
    end
end

function level_restart(msg)
    if (gNetworkPlayers[0].currLevelNum == gGlobalSyncTable.sameLevel) and (gNetworkPlayers[0].currAreaIndex == gGlobalSyncTable.sameArea) and (gNetworkPlayers[0].currActNum == gGlobalSyncTable.sameAct) then
        save_pos()
        --Hopefully will prevent cases where "/warp restart" can theoretically save and load positions upon level restart if someone else uses "/warp reset" at the same time in a different level.
        if msg == "RESET" then resetDue = true --Easy way of letting players (other than the restart initiator) know to load their saved pos if they're in the same level as the initiator since gGlobalSyncTable is strict.
        else --"RESTART"
            resetDue = false --Just to be sure.
            save_y, save_x, save_z, save_angle_y, save_angle_x = nil
        end

        --Most of these ideas are also from Agent X's "Flood" mod.
        init_single_mario(gMarioStates[0])
        gMarioStates[0].health = 0x880
        gMarioStates[0].healCounter = 0
        gMarioStates[0].hurtCounter = 0
        warp_restart_level()
    end
end

local function level_res(msg) --Resets the current level instance. May move you to the start of the level. Might also still break if multiple people are trying to use it at the same time across separate levels.
    if warp_restart_level() == false then
        local_popup("Unable to restart or reset the level.", local_popup_state)
        return false
    else
        local verb = nil --To customize the level notification popup message.
        if msg == "RESTART" then verb = "restarted"
        elseif msg == "RESET" then
            verb = "reset"
            gGlobalSyncTable.saveDue = true
        end

        if gGlobalSyncTable.ipopups then --Encapsulating these function calls within pcall is probably unnecessary.
            if (gNetworkPlayers[0].currActNum == 0) or (course_is_main_course(gNetworkPlayers[0].currCourseNum) == false) then
                if pcall(get_level_name, gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex) then
                    if get_level_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex) ~= nil then
                        djui_popup_create_global(network_get_player_text_color_string(0)..gNetworkPlayers[0].name .. "\\#ffffff\\ " .. tostring(verb) .. ": \\#10ff10\\" .. get_level_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex), 2)
                    end
                else log_to_console("get_level_name probably broke something") end
            else
                if pcall(get_level_name, gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex) then
                    if get_level_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex) ~= nil then
                        if pcall(get_star_name, gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currActNum) then
                            if get_star_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currActNum) ~= nil then
                                djui_popup_create_global(network_get_player_text_color_string(0)..gNetworkPlayers[0].name
                                .. "\\#ffffff\\ " .. tostring(verb) .. ": \\#10ff10\\" .. get_level_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex)
                                .. "\\#ffffff\\, \\#ffff00\\" .. get_star_name(gNetworkPlayers[0].currCourseNum, gNetworkPlayers[0].currActNum), 2)
                            end
                        else log_to_console("get_star_name probably broke something") end
                    end
                else log_to_console("get_level_name probably broke something") end
            end
        end
        gGlobalSyncTable.sameLevel = gNetworkPlayers[0].currLevelNum
        gGlobalSyncTable.sameArea =  gNetworkPlayers[0].currAreaIndex
        gGlobalSyncTable.sameAct =  gNetworkPlayers[0].currActNum

        --Very schizophrenic way to try to stupid-proof level_restart() and myself.
        if msg == "RESTART" then network_send(true, { restart = false }) --Make restart equal to "RESTART" later instead of "false" if problems happen.
        elseif msg == "RESET" then network_send(true, { restart = true }) end --Make restart equal to "REST" later instead of "true" if problems happen.
        level_restart(msg)
    end
    return true
end

--Modified function from Agent X's "Flood" mod. Helps makes sure that everyone "exits" the level at the same time to create a new level instance.
local function on_packet_receive(dataTable) --Hopefully, this won't bite me in the ass later with bugs and unexpected behavior.
    if dataTable.restart then level_restart("RESET")
    elseif dataTable.restart == false then level_restart("RESTART")
    elseif dataTable.extra == "peach" then level_trigger_warp(gMarioStates[0], 23)
    elseif dataTable.extra == "cake" then level_trigger_warp(gMarioStates[0], WARP_OP_CREDITS_END) end
end

--Vanilla Mario 64 level values can be found here: https://github.com/djoslin0/sm64ex-coop/blob/coop/docs/lua/constants.md#enum-LevelNum
--Vanilla Mario 64 course indexes for debugging: https://github.com/djoslin0/sm64ex-coop/blob/coop/text/us/courses.h
local function warp_cmd(msg)--Encountered a bug where one of the test clients couldn't execute any warp commands no matter what until relaunching the game. Don't know how to replicate it.
    msg = strip_colors(msg)
    local args = {} --Chat command input logic is mostly from the "Object Spawner" mod.
    for argument in msg:gmatch("%S+") do table.insert(args, argument) end

    if (gGlobalSyncTable.HostOnly == false) or (network_is_server()) then    
        if string.upper(args[1]) == "TO" then --Warps the player to the given coordinates. Will try to take you to the default spawn point / warp node for that area.
            if tonumber(args[2]) ~= nil and tonumber(args[3]) ~= nil and tonumber(args[4]) ~= nil and tonumber(args[5]) ~= nil then --int aLevel aArea aAct aWarpId
                if warp_to_warpnode(tonumber(args[2]), tonumber(args[3]), tonumber(args[4]), tonumber(args[5])) == false then
                    local_popup("Warp to level \\#ff0000\\" .. args[2] .. "\\#ffffff\\, area \\#ff0000\\" .. args[3] .. "\\#ffffff\\, act \\#ff0000\\" .. args[4] .. "\\#ffffff\\, warp node \\#ff0000\\" .. args[5] .. "\\#ffffff\\ failed.", local_popup_state)
                else warp_to_warpnode(tonumber(args[2]), tonumber(args[3]), tonumber(args[4]), tonumber(args[5])) end
            elseif tonumber(args[2]) ~= nil and tonumber(args[3]) ~= nil and tonumber(args[4]) ~= nil then --int LevelNum AreaIndex ActNum
                if warp_to_level(tonumber(args[2]), tonumber(args[3]), tonumber(args[4])) == false then
                    local_popup("Warp to level \\#ff0000\\" .. args[2] .. "\\#ffffff\\, area \\#ff0000\\" .. args[3] .. "\\#ffffff\\, act \\#ff0000\\" .. args[4] .. "\\#ffffff\\ failed.", local_popup_state)
                else warp_to_level(tonumber(args[2]), tonumber(args[3]), tonumber(args[4])) --Be careful with the ActNum parameter. The game actually usually allows you to warp to that act (read: star level) regardless if they're normally ever accessible.
                end
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp to \\#10ff10\\LevelNum AreaIndex ActNum (Optional)WarpId") end --level = course id, area = default "1", act = star number, WarpId = seems to actually ask for destNode instead of aWarpId
        elseif string.upper(args[1]) == "CASTLE" then --Warp to the front of the entrance of the specified course (id) if applicable.
            if tonumber(args[2]) ~= nil then --int aLevel
                if warp_to_castle(tonumber(args[2])) == false then
                    local_popup("Warp to castle level \\#ff0000\\" .. args[2] .. "\\#ffffff\\ failed.", local_popup_state)
                else warp_to_castle(tonumber(args[2])) end
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp castle \\#10ff10\\aLevel") end
        elseif string.upper(args[1]) == "START" then --Return to the starting map.
            if warp_to_start_level() == false then local_popup("Start level unavailable.", local_popup_state)
            else warp_to_start_level() end
        elseif string.upper(args[1]) == "RESTART" then --Resets the current level instance. Moves you to the start of the level.
            level_res(string.upper(args[1]))
        elseif string.upper(args[1]) == "RESET" then --Resets the current level instance.
            level_res(string.upper(args[1]))
        elseif string.upper(args[1]) == "CHANGE" then --Warps you to the specified area in the level. Saves your position between areas.
            if tonumber(args[2]) ~= nil then --Doesn't actually check if the area change is valid for the current level.
                smlua_level_util_change_area(tonumber(args[2])) --int AreaIndex
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp change \\#10ff10\\AreaIndex") end
        elseif string.upper(args[1]) == "EXIT" then --Either makes you completely exit the current level or tries to take you to the parent level before exiting the current course.
            if tonumber(args[2]) == 1 or tonumber(args[2]) == nil then --Same behavior as selecting "Exit Course" from the pause menu.
                if level_trigger_warp(gMarioStates[0], WARP_OP_EXIT) ~= nil then
                    level_trigger_warp(gMarioStates[0], WARP_OP_EXIT) --Can work on maps where you can't normally access the "Exit Course" option from the pause menu.
                else local_popup("Unable to exit the course.", local_popup_state) end
            elseif tonumber(args[2]) == 2 then --Completely exit the level. Usually doesn't force you into an animation unlike the traditional "Exit Course option".
                if warp_exit_level(10) ~= true then local_popup("Unable to exit the level.", local_popup_state)
                else warp_exit_level(10) end --arg is just warp delay (int).
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp change \\#10ff10\\AreaIndex") end
        elseif string.upper(args[1]) == "GET" then --Outputs custom level details to the console. Only works with custom levels (e.g. "hangout" maps). Useless for level overrides / replacements (e.g. most romhacks).
            if tonumber(args[2]) ~= nil then
                if level_is_vanilla_level(tonumber(args[2])) ~= true and smlua_level_util_get_info(tonumber(args[2])) ~= nil then --int LevelId
                    log_to_console("Custom level num: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).levelNum))
                    log_to_console("Custom level course num: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).courseNum))
                    log_to_console("Custom level full name: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).fullName))
                    log_to_console("Custom level mod index: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).modIndex))
                    if smlua_level_util_get_info(tonumber(args[2])).next ~= nil then
                        log_to_console("Next custom level: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).next.fullName))
                    else log_to_console("No next custom level") end
                    log_to_console("Custom level script entry name: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).scriptEntryName))
                    log_to_console("Custom level short name: " .. tostring(smlua_level_util_get_info(tonumber(args[2])).shortName))
                else local_popup("/warp get: custom level N/A", local_popup_state) end
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp get \\#10ff10\\LevelNum") end
        elseif string.upper(args[1]) == "CGET" then --Outputs custom level details to the console. Only works with custom levels (e.g. "hangout" maps). Useless for level overrides / replacements (e.g. most romhacks).
            if tonumber(args[2]) ~= nil then
                if level_is_vanilla_level(tonumber(args[2])) ~= true and smlua_level_util_get_info_from_course_num(tonumber(args[2])) ~= nil then --int CourseNum
                    log_to_console("Custom level num: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).levelNum))
                    log_to_console("Custom level course num: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).courseNum))
                    log_to_console("Custom level full name: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).fullName))
                    log_to_console("Custom level mod index: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).modIndex))
                    if smlua_level_util_get_info_from_course_num(tonumber(args[2])).next ~= nil then
                        log_to_console("Next custom level: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).next.fullName))
                    else log_to_console("No next custom level") end
                    log_to_console("Custom level script entry name: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).scriptEntryName))
                    log_to_console("Custom level short name: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(args[2])).shortName))
                else local_popup("/warp cget: custom level N/A", local_popup_state) end
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp cget \\#10ff10\\CourseNum") end
        elseif string.upper(args[1]) == "SGET" then --Outputs custom level details to the console. Only works with custom levels (e.g. "hangout" maps). Useless for level overrides / replacements (e.g. most romhacks).
            if tostring(args[2]) ~= nil then
                if smlua_level_util_get_info_from_short_name(tostring(args[2])) ~= nil then --string ShortName. This shit is actually case-sensitive.
                    log_to_console("Custom level num: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).levelNum))
                    log_to_console("Custom level course num: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).courseNum))
                    log_to_console("Custom level full name: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).fullName))
                    log_to_console("Custom level mod index: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).modIndex))
                    if smlua_level_util_get_info_from_short_name(tostring(args[2])).next then
                        log_to_console("Next custom level: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).next.fullName))
                    else log_to_console("No next custom level") end
                    log_to_console("Custom level script entry name: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).scriptEntryName))
                    log_to_console("Custom level short name: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(args[2])).shortName))
                else local_popup("/warp sget: custom level N/A", local_popup_state) end
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp sget \\#10ff10\\ShortName") end
        elseif string.upper(args[1]) == "NGET" then --Outputs the current area's specified warp node details to the console.
            if tonumber(args[2]) ~= nil then --int WarpNodeId
                if area_get_warp_node(tonumber(args[2])) ~= nil then --Command fails for warp node id 0 even if teleporting to it is valid.
                    log_to_console("destLevel: " .. tostring(area_get_warp_node(tonumber(args[2])).node.destLevel))
                    log_to_console("destArea: " .. tostring(area_get_warp_node(tonumber(args[2])).node.destArea))
                    log_to_console("destNode: " .. tostring(area_get_warp_node(tonumber(args[2])).node.destNode))
                    log_to_console("id: " .. tostring(area_get_warp_node(tonumber(args[2])).node.id))
                else local_popup("/warp nget: warp node N/A", local_popup_state) end
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp wget \\#10ff10\\WarpId") end
        elseif string.upper(args[1]) == "POPUPS" then--Enable or disable pop-up messages.
            if network_is_server() then
                if args[2] ~= nil then
                    if string.upper(args[2]) == "ON" then
                        gGlobalSyncTable.ipopups = true
                        djui_chat_message_create("Restart \\#ffff00\\pop-ups \\#ffffff\\will \\#10ff10\\now show up.")
                    elseif string.upper(args[2]) == "OFF" then
                        gGlobalSyncTable.ipopups = false
                        djui_chat_message_create("Restart \\#ffff00\\pop-ups \\#ffffff\\will \\#ff0000\\no longer show up.")
                    elseif string.upper(args[2]) == "LOCAL" then--Can't combine this condition with "or args[2] == nil" into a single line because of string.upper() not liking nil.
                        local_popup_state = not local_popup_state
                        if local_popup_state then djui_chat_message_create("Local \\#ffff00\\pop-ups \\#ffffff\\will \\#10ff10\\now show up.")
                        else djui_chat_message_create("Local \\#ffff00\\pop-ups \\#ffffff\\will \\#ff0000\\no longer show up.") end
                    else djui_chat_message_create("Usage of command: \\#ffff00\\/warp popups \\#00ff00\\on\\#ffffff\\|\\#ff0000\\off\\#ffffff\\|\\#ffff00\\local") end
                else
                    local_popup_state = not local_popup_state
                    if local_popup_state then djui_chat_message_create("Local \\#ffff00\\pop-ups \\#ffffff\\will \\#10ff10\\now show up.")
                    else djui_chat_message_create("Local \\#ffff00\\pop-ups \\#ffffff\\will \\#ff0000\\no longer show up.") end
                end
            else djui_chat_message_create("Only the \\#ffff00\\host \\#ffffff\\can use this command.") end
        elseif string.upper(args[1]) == "HOST_ONLY" then --Allow or deny everyone but the host the ability to use warp commands.
            if network_is_server() then --Deliberate choice to nod add toggles since this command is not insignificant.
                if string.upper(args[2]) == "ON" then
                    gGlobalSyncTable.HostOnly = true
                    djui_popup_create_global("Warping is now \\#ffff00\\host only.", 1)
                elseif string.upper(args[2]) == "OFF" then
                    gGlobalSyncTable.HostOnly = false
                    djui_popup_create_global("Warping is no longer \\#ffff00\\host only.", 1)
                else djui_chat_message_create("Usage of command: \\#ffff00\\/warp host_only \\#00ff00\\on\\#ffffff\\|\\#ff0000\\off") end
            else djui_chat_message_create("Only the \\#ffff00\\host \\#ffffff\\can use this command.") end
        elseif string.upper(args[1]) == "HELP" then --Organized by predicted use-frequency.
            djui_chat_message_create("Available commands: "
            .. "\n - \\#ffff00\\[to]\\#ffffff\\ [LevelNum] [AreaIndex] [ActNum] [(Optional) WarpId]: Warps the player to the given coordinates."
            .. "\n - \\#ffff00\\[castle]\\#ffffff\\ [aLevel]: Warp to the entrance of the specified course (id) if applicable."
            .. "\n - \\#ffff00\\[start]\\#ffffff\\: Return to the starting map."
            .. "\n - \\#ffff00\\[restart]\\#ffffff\\: Resets the current level instance. Moves you to the start of the level."
            .. "\n - \\#ffff00\\[reset]\\#ffffff\\: Resets the current level instance."
            .." \n - \\#ffff00\\[exit]\\#ffffff\\ [ |1|2]: Exit the current course.\n") --Output stops here in-game.
        elseif string.upper(args[1]) == "HELP2" then
            djui_chat_message_create("Available commands: "
            .. "\n - \\#ffff00\\[change]\\#ffffff\\ [AreaIndex]: Warps you to the specified area in the level. Saves your position."
            .. "\n - \\#ffff00\\( |c|s)[get]\\#ffffff\\ [LevelNum|CourseNum|ShortName]: Outputs custom level details to the console."
            .. "\n - \\#ffff00\\[nget]\\#ffffff\\ [WarpId]: Outputs the current area's specified warp node details to the console."
            .. "\n - \\#ffff00\\[popups]\\#ffffff\\ [on|off|local]: Enable or disable pop-up messages."
            .. "\n - \\#ffff00\\[host_only]\\#ffffff\\ [on|off]: Allow everyone or deny everyone but the host the ability to use warp commands.")
        elseif string.upper(args[1]) == "PW" then --It's just here for completeness. Expect very little support for this option for now.
            if tonumber(args[2]) ~= nil then initiate_painting_warp(tonumber(args[2])) --int PaintingIndex
            else djui_chat_message_create("Usage of command: \\#ffff00\\/warp pw \\#10ff10\\PaintingIndex") end
        elseif string.upper(args[1]) == "SHOW" then
            pauseMenuShowLevelID = not pauseMenuShowLevelID
            local_popup("Pause menu debug hud: \\#ffff00\\" .. tostring(pauseMenuShowLevelID), local_popup_state)
        elseif string.upper(args[1]) == "EXTRA" then --Extra actions for fun. Might cause crashes.
            if args[2] ~= nil then
                if string.upper(args[2]) == "PEACH" then --Trigger the Peach ending cutscene without needing to grab a Grand Star. Will prevent you from pausing until you change screens if the romhack doesn't have the cutscene.
                    if args[3] ~= nil then
                        if string.upper(args[3]) == "ALL" then
                            if network_is_server() then
                                network_send(false, { extra = "peach" })
                                level_trigger_warp(gMarioStates[0], 23)
                            else djui_chat_message_create("Only the host can use \\#ffff00\\/warp extra peach \\#10ff10\\all") end
                        else djui_chat_message_create("Unsupported extra command option.") end
                    else level_trigger_warp(gMarioStates[0], 23) end
                elseif string.upper(args[2]) == "CAKE" then --After credits cake end.
                    if args[3] ~= nil then
                        if string.upper(args[3]) == "ALL" then
                            if network_is_server() then
                                network_send(false, { extra = "cake" })
                                level_trigger_warp(gMarioStates[0], WARP_OP_CREDITS_END)
                            else djui_chat_message_create("Only the host can use \\#ffff00\\/warp extra cake \\#10ff10\\all") end
                        else djui_chat_message_create("Unsupported extra command option.") end
                    else level_trigger_warp(gMarioStates[0], WARP_OP_CREDITS_END) end
                else djui_chat_message_create("Unsupported extra command.") end
            else djui_chat_message_create("Unsupported extra command.") end
        else djui_chat_message_create("Unrecognized command. Please use \\#ffff00\\/warp help|help2\\#ffffff\\ for a list of supported commands.") end
    else djui_chat_message_create("Only the \\#ffff00\\host \\#ffffff\\can use this command.") end
    return true
end

--Taken from Farris's "Streaming Music Mod" to help test and debug this mod with the hud_render() function.
--Left in to help those who are not familiar with ids.
local function hud_render()
    if (pauseMenuShowLevelID == true and is_game_paused()) then
        djui_hud_set_resolution(RESOLUTION_DJUI);
        djui_hud_set_font(FONT_NORMAL);
        local screenWidth = djui_hud_get_screen_width()
		local screenHeight = djui_hud_get_screen_height()
        local height = 64
        local y = screenHeight - height
		local text = "COURSE#: " .. gNetworkPlayers[0].currCourseNum .. " LEVEL AREA SEQ: " .. gNetworkPlayers[0].currLevelAreaSeqId .. " LEVEL ID: " .. gNetworkPlayers[0].currLevelNum .. " AREA INDEX: ".. gNetworkPlayers[0].currAreaIndex .. " ACT #: " .. gNetworkPlayers[0].currActNum
		djui_hud_print_text(text, 5, y, 1);
    end
end

hook_event(HOOK_MARIO_UPDATE, mask_attempt)
hook_event(HOOK_ON_PACKET_RECEIVE, on_packet_receive)
hook_event(HOOK_ON_HUD_RENDER, hud_render)
hook_event(HOOK_ON_WARP, load_pos) --There will still be a slight delay where you can see the models of the other players render into existence.
hook_chat_command('warp', "[to|castle|start|restart|reset|change|exit|( |c|s)get|nget|popups|host_only|help|help2]", warp_cmd)